# BFS of graph
## Easy
<div class="problems_problem_content__Xm_eO"><p><span style="font-size:18px">Given a directed&nbsp;graph. The task is to do Breadth First Traversal of this graph starting from 0.<br>
<strong>Note: </strong>One can move from node u&nbsp;to node v&nbsp;only if there's an edge from u&nbsp;to v and find the BFS traversal of the graph starting from the 0th vertex,</span><span style="font-size:18px">&nbsp;from left to right according to the graph. Also, you should only take nodes directly or indirectly connected from Node 0 in consideration.</span></p>

<p><br>
<span style="font-size:18px"><strong>Example 1:</strong></span></p>

<pre><span style="font-size:18px"><strong>Input:</strong>
</span><img alt="" src="data:image/png;base64,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"><span style="font-size:18px">
<strong>Output:</strong> 0 1 2 3 4
<strong>Explanation</strong>: 
0 is connected to 1 , 2 , 3.
2 is connected to 4.
so starting from 0, it will go to 1 then 2
then 3.After this 2 to 4, thus bfs will be
0 1 2 3 4.</span>
</pre>

<p><span style="font-size:18px"><strong>Example 2:</strong></span></p>

<pre><span style="font-size:18px"><strong>Input:</strong>
</span><img alt="" src="data:image/png;base64,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"><span style="font-size:18px">
<strong>Output:</strong> 0 1 2
<strong>Explanation</strong>:
0 is connected to 1 , 2.
so starting from 0, it will go to 1 then 2,
thus bfs will be 0 1 2. </span>
</pre>

<p><br>
<span style="font-size:18px"><strong>Your task:</strong><br>
You dont need to read input or print anything. Your task is to complete the function&nbsp;<strong>bfsOfGraph()</strong>&nbsp;which takes the integer V denoting the number of vertices and adjacency list as input parameters and returns </span>&nbsp;<span style="font-size:18px">a list containing the BFS traversal of the graph starting from the 0th vertex from left to right.</span></p>

<p><br>
<span style="font-size:18px"><strong>Expected Time Complexity:&nbsp;</strong>O(V + E)<br>
<strong>Expected Auxiliary Space:&nbsp;</strong>O(V)</span></p>

<p><br>
<span style="font-size:18px"><strong>Constraints:</strong><br>
1 ≤ V, E ≤ 10<sup>4</sup></span></p>
</div>